/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigAnimations;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.math.AABBf;
import net.diebuddies.math.Math;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.ParticleSpawn;
import net.diebuddies.physics.settings.blocks.BlockSetting;
import net.diebuddies.physics.settings.mobs.MobSetting;
import net.minecraft.class_1299;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3887;
import net.minecraft.class_761;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PhysicsEntity {
    private final Matrix4d transformation;
    private final Matrix4d oldTransformation;
    private final Matrix4f renderTransformation = new Matrix4f();
    private Quaternionf rotation;
    private Quaternionf oldRotation;
    public List<Model> models = new ObjectArrayList(1);
    public Type type;
    public float time;
    public AABBf rescale;
    public final Vector3f pivot = new Vector3f();
    public float scale = 1.0f;
    private int color = -1;
    public final Vector3f scalePhysics = new Vector3f(1.0f);
    public final Vector3f enlargeHitbox = new Vector3f(1.0f);
    public byte physicsGroup = (byte)2;
    public byte physicsMask = (byte)23;
    public Object info;
    public class_2498 sound;
    public long lastSoundTime = 0L;
    public class_3887 feature = null;
    private int cachedBrightness;
    private class_2338.class_2339 cachedBrightnessPos;
    public float lifetime;
    public float lifetimeVariance;
    private Animation animation;
    private float boundingSphereRadius = -1.0f;
    public boolean noVolume;
    public boolean backfaceCulling = true;
    public boolean staticPhysics = false;
    public boolean shade = true;
    private boolean dead;
    public List<PhysicsEntity> children = new ObjectArrayList();

    public PhysicsEntity(Type type, Object info) {
        this.info = info;
        this.animation = ConfigAnimations.DEFAULT_ANIMATION;
        if (info != null) {
            if (info instanceof class_2680) {
                class_2680 state = (class_2680)info;
                this.sound = state.method_26231();
                if (type == Type.BLOCK || type == Type.VINE) {
                    BlockSetting blockSetting = ConfigBlocks.getBlockSetting(state.method_26204());
                    if (type != Type.VINE) {
                        this.scale = (float)blockSetting.getScale();
                    }
                    this.animation = blockSetting.getAnimation();
                    this.lifetime = (float)blockSetting.getLifetime();
                    this.lifetimeVariance = (float)blockSetting.getLifetimeVariance();
                }
            } else if (info instanceof class_1299) {
                class_1299 entityType = (class_1299)info;
                if (type == Type.MOB) {
                    MobSetting mobSetting = ConfigMobs.getMobSetting(entityType);
                    this.animation = mobSetting.getAnimation();
                    this.lifetime = (float)mobSetting.getLifetime();
                    this.lifetimeVariance = (float)mobSetting.getLifetimeVariance();
                }
            }
        }
        this.transformation = new Matrix4d();
        this.oldTransformation = new Matrix4d();
        this.models.add(new Model());
        this.type = type;
    }

    public Matrix4d getTransformation() {
        return this.transformation;
    }

    public Matrix4d getOldTransformation() {
        return this.oldTransformation;
    }

    public Matrix4f getRenderTransformation() {
        return this.renderTransformation;
    }

    public Quaternionf getRotation() {
        return this.rotation;
    }

    public Quaternionf getOldRotation() {
        return this.oldRotation;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void setOldRotation(Quaternionf oldRotation) {
        this.oldRotation = oldRotation;
    }

    public float getBoundingSphereRadius() {
        if ((double)this.boundingSphereRadius < 0.0) {
            for (int i = 0; i < this.models.size(); ++i) {
                this.boundingSphereRadius = java.lang.Math.max(this.boundingSphereRadius, this.models.get((int)i).mesh.getRadius());
            }
            this.boundingSphereRadius *= java.lang.Math.max(this.scalePhysics.x, java.lang.Math.max(this.scalePhysics.y, this.scalePhysics.z)) * this.scale;
        }
        return this.boundingSphereRadius;
    }

    public void destroy() {
        this.destroyModels();
    }

    public void destroyModels() {
        if (this.models != null) {
            for (int i = 0; i < this.models.size(); ++i) {
                Model model = this.models.get(i);
                if (model.memorySegment == null) continue;
                model.memorySegment.free();
                model.memorySegment = null;
            }
        }
    }

    public int getLight(class_1937 level, class_2338.class_2339 blockPos) {
        if (!StarterClient.disableLightingCache) {
            if (this.cachedBrightnessPos == null) {
                this.cachedBrightnessPos = new class_2338.class_2339(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            } else if (this.cachedBrightnessPos.method_10263() == blockPos.method_10263() && this.cachedBrightnessPos.method_10264() == blockPos.method_10264() && this.cachedBrightnessPos.method_10260() == blockPos.method_10260()) {
                return this.cachedBrightness;
            }
        }
        class_2680 bState = level.method_8320((class_2338)blockPos);
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        int brightness = 0;
        if (!bState.method_26225()) {
            brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
        } else {
            bState = level.method_8320((class_2338)blockPos.method_10103(x, y + 1, z));
            if (!bState.method_26225()) {
                brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
            } else {
                bState = level.method_8320((class_2338)blockPos.method_10103(x, y - 1, z));
                if (!bState.method_26225()) {
                    brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                } else {
                    bState = level.method_8320((class_2338)blockPos.method_10103(x, y, z - 1));
                    if (!bState.method_26225()) {
                        brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                    } else {
                        bState = level.method_8320((class_2338)blockPos.method_10103(x + 1, y, z));
                        if (!bState.method_26225()) {
                            brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                        } else {
                            bState = level.method_8320((class_2338)blockPos.method_10103(x, y, z + 1));
                            if (!bState.method_26225()) {
                                brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                            } else {
                                bState = level.method_8320((class_2338)blockPos.method_10103(x - 1, y, z));
                                if (!bState.method_26225()) {
                                    brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                                }
                            }
                        }
                    }
                }
            }
        }
        blockPos.method_10103(x, y, z);
        if (!StarterClient.disableLightingCache) {
            this.cachedBrightness = brightness;
            this.cachedBrightnessPos.method_10103(x, y, z);
        }
        return brightness;
    }

    public void invalidateBrightness() {
        this.cachedBrightnessPos = null;
    }

    public class_2338.class_2339 getCachedBrightnessPos() {
        return this.cachedBrightnessPos;
    }

    public double getDespawnSpeed() {
        return this.animation.speed;
    }

    public void spawnDeathAnimation(PhysicsWorld world, boolean playSound) {
        if (!this.dead) {
            class_1937 level = world.getWorld();
            List<ParticleSpawn> particleSpawns = this.animation.particleSpawns;
            for (int i = 0; i < particleSpawns.size(); ++i) {
                ParticleSpawn particleSpawn = particleSpawns.get(i);
                if (particleSpawn.particle == null || !((double)Math.random() < particleSpawn.spawnChance)) continue;
                for (int j = 0; j < particleSpawn.amount; ++j) {
                    double halfSpread = particleSpawn.spread * 0.5;
                    double px = this.transformation.m30() + world.getOffset().x + (double)Math.random() * particleSpawn.spread - halfSpread;
                    double py = this.transformation.m31() + world.getOffset().y + (double)Math.random() * particleSpawn.spread - halfSpread;
                    double pz = this.transformation.m32() + world.getOffset().z + (double)Math.random() * particleSpawn.spread - halfSpread;
                    level.method_8406(particleSpawn.particle, px, py, pz, particleSpawn.vx, particleSpawn.vy, particleSpawn.vz);
                }
                if (particleSpawn.sound == null || !playSound) continue;
                float pitch = 0.85f + Math.random() * 0.3f;
                level.method_8486(this.transformation.m30() + world.getOffset().x, this.transformation.m31() + world.getOffset().y, this.transformation.m32() + world.getOffset().z, particleSpawn.sound, class_3419.field_15251, (float)particleSpawn.soundVolume, pitch, true);
            }
            this.dead = true;
        }
    }

    public float getVolume() {
        if (this.rescale == null) {
            return 1.0f;
        }
        Vector3f max = this.rescale.end;
        Vector3f min = this.rescale.start;
        return (max.x - min.x) * (max.y - min.y) * (max.z - min.z);
    }

    public void startDespawnAnimation(class_1937 level) {
        if (this.time > this.animation.speed) {
            this.time = this.animation.speed;
        }
    }

    public boolean isDespawning() {
        return this.time <= this.animation.speed;
    }

    public float getDespawnScale(class_1937 level) {
        if (this.time > this.animation.speed) {
            return 1.0f;
        }
        if ((double)this.time <= 0.0) {
            return 0.0f;
        }
        return this.animation.getCurve().get(this.time / this.animation.speed);
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public AnimationType getAnimationType() {
        return this.animation.despawnType;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) * 0.003921569f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) * 0.003921569f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) * 0.003921569f;
    }

    public float getAlpha() {
        return (float)(this.color >> 24 & 0xFF) * 0.003921569f;
    }

    public int getBGRA() {
        return this.color;
    }

    public static enum Type {
        MOB,
        BLOCK,
        VINE,
        ITEM,
        PARTICLE,
        LIQUID,
        SMOKE,
        OTHER;

    }
}

